/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed*0.3
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.
//
// With VGHD if no other texture has been selected by the .scn file iChannel0
// will pick up the performer or the performers name sprite.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

vec2 rotate(in vec2 p, in float t)
{
   return p*cos(-t)+vec2(p.y, -p.x)*sin(-t);
}

float sdTorus(in vec3 p, in vec2 t)
{
   vec2 q = vec2(length(p.xz)-t.x, p.y);
   return length(q)-t.y;
}

void main(void)
{
   vec2 p = (2.0*gl_FragCoord.xy-iResolution.xy)/iResolution.y;
   vec3 col = vec3(0.0);
   const float steps = 50.0;
   float pers = 3.0;
   for(float i=0.0; i<=steps; i++)
   {
      float z = 1.0-2.0*pow(i/steps,2.0);
      float s = pers/(pers+z);
      vec3 pos = vec3(p*s, z);
      pos.zx = rotate(pos.zx, iGlobalTime*0.5);
      pos.yz = rotate(pos.yz, iGlobalTime*0.6);
      if (sdTorus(pos, vec2(0.8,0.3)) < 0.001)
      {
        col =  texture2D(iChannel0, mod(pos.xy,1.0)).rgb;
        break;
      }
    }
   gl_FragColor = vec4(col, length(col)*100.0);
}